<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS - Generate Test Cases";
//$page_breadcrumb = "Generate Test Cases";
$page_breadcrumb = "Generate Test Cases &amp; Start Testing (1 of 2)";
//$page_h1 = "Generate Test Cases &amp; Start Testing (1 of 2)";
$page_h1 = "Selecting the Features of the String Search Tool to Test";
//$isSsHome = 1; // setting this variable will help ft_ss_head.php in rendering the page as we call it next...
include "ft_ss_need_logs.php";
include_once('../include/ss-global.php');

if ($ftlogs_mounted == 1) { // we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php  
	// (via ft_ss_need_logs.php). If the drive's not mounted, suppress/do not print the rest of this page.
?>
<p>Use this page to select the features of the tool you want to test.   

<p>You need to specify the following:
<ol>
	<li>The name and version of the tool</li>
	<li>The data sets you want to test</li>
	<li>The search engines you want to test</li>
   <li>The features you want to test the tool for <!--<b>Select <u>only</u> 
the features you want to test your tool for.</b>--></li> 
</ol>
</p><br>

<form method="POST" action="savetestconfigfile.php"> 
<h2 style="font-size:1.7em; color:#008000"><b>1 Tool Name and Version</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
	<!--<p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->
	<p>
	Enter the tool name: &nbsp;&nbsp;&nbsp;&nbsp;<input name="toolname" type="text" size="35" required><br> 
	Enter the tool version: &nbsp;<input name="toolversion" type="text" size="35" required><br>
	</p>
</div><br>
	
<h2 style="font-size:1.7em; color:green"><b>2 Search Engines to Test</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<!-- <p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->

<p>A search tool may have more than one search engine that can be used. Usually this is
a choice between a live search (Scans the data set for a match to a target) or an indexed
search (before doing any searching the data set is scanned and an index is built so that
a search is just a look up in the index).</p>

<p>Select the search engines that you want to test for the tool.<br>

<?php
foreach($engines_dict as $key => $value){
	echo '<input name="engines[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
}	
?>	
</p>
<p>If Other is selected, enter the other search engine name:&nbsp; <input name="se_name" type="text" value=""></p>
</div><br>


<h2 style="font-size:1.7em; color:green"><b>3 Data Sets to Test</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<!-- <p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->
<p>There are two test data sets that can be downloaded to test 
a search tool. The Windows based data set has three formatted
partitions (FAT32, ExFAT and NTFS), a unformatted partition and
some strings in locations unreachable by normal file system access.
The second test image has three UNIX-like formatted partitions (OSX Journaled,
OSX Case Sensitive, APFS (Apple File System) and Linux ext4).</p>

<p>Select the data sets that you want to test for the tool.<br>

<input name="datasets[]" value="Windows" type="checkbox">&nbsp; Windows: FAT, ExFat and NTFS <br>
<input name="datasets[]" value="UNIX" type="checkbox">&nbsp; UNIX: ext4, APFS (Apple File System), OSX Journaled and OSX Case-sensitive<br><br>
	
<?php
foreach($datasets_dict as $key => $value){
	echo '<input name="datasets[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
}	
?>	

	
	
</p>
	
</div><br>

<h2 style="font-size:1.7em; color:green"><b>4 Tool Features to Test</b><br></h2>
      <p>Select the tool features you want to test. <!--<span style="color:red;"><b>SELECT <u>ONLY</u> 
    	THE FEATURES YOU WANT TO TEST THE TOOL FOR.</b></span>--><br></p>
    
    <h3 style="font-size:1.6em; color:#9D0F19"><b>Basic Search Features</b></h3>
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
        url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

<!--		<p><input name="basic[]" value="ft-ss-01" type="checkbox"> &nbsp;Simple search. Test that the tool can find a single ASCII string.<br> 
        <input name="basic[]" value="ft-ss-02" type="checkbox"> &nbsp;Substring match and ignore case. Test the substring match and ignore case features of the tool.<br> 
        <input name="basic[]" value="ft-ss-03" type="checkbox"> &nbsp;Whole word search. Test searching for a whole word match vs a substring match.</p>-->

		<p>In this section, select the basic string search features you want to test for the tool. At a minimum, you should consider testing the basic features you use in your lab.</p>

		<p>What basic string search features do you want to test?<br>
		
		<input name="basic[]" value="ft-ss-01" type="checkbox"> &nbsp;Search ASCII<br> 
        <input name="basic[]" value="ft-ss-02" type="checkbox"> &nbsp;Search ignore case<br> 
        <input name="basic[]" value="ft-ss-02" type="checkbox"> &nbsp;Search for a substring<br>
		<input name="basic[]" value="ft-ss-03" type="checkbox"> &nbsp;Search for words (whole word match vs a substring match)</p>
	</div>
    <br>  
		
      <!--<h2 style="font-size:1.6em">Operations on Removable Media</h2>-->  
<!--      <h3 style="font-size:1.6em; color:#9D0F19"><b>Operations on Removable Media</b></h3>-->
    <h3 style="font-size:1.6em; color:#9D0F19"><b>Logical Combinations</b></h3>
 	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
    url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of logical combinations you want to test for the 
		tool. At a minimum, you should consider testing the types of logical combinations you use in your lab.</p>

        <p>What logical combinations do you want to test?<br>

        <input name="logical[]" value="ft-ss-04" type="checkbox">&nbsp; Logical AND <br>
        <input name="logical[]" value="ft-ss-05" type="checkbox">&nbsp; Logical OR <br>
        <input name="logical[]" value="ft-ss-06" type="checkbox">&nbsp; Logical NOT &nbsp;</p>		
    </div>
    <br>

    <h3 style="font-size:1.6em; color:#9D0F19"><b>Search Unicode Text</b></h3>
 	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
    url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of Unicode searches you want to test for the tool. At a minimum, you should consider testing the types of Unicode searches you use your lab.</p>
		
        <p>What types of Unicode searches do you want to test?<br>
		
		<input name="unicode[]" value="latin" type="checkbox" id="atasetting"> &nbsp;Search Unicode Latin (French & German)<br>
        <input name="unicode[]" value="cjk-char" type="checkbox" id="satasetting"> &nbsp;Search Unicode Chinese/Japanese ideograms (Asian)<br>
        <input name="unicode[]" value="cjk-hangul" type="checkbox"> &nbsp;Search Unicode CJK Korean Hangul (Asian)<br>
        <input name="unicode[]" value="cjk-kana" type="checkbox"> &nbsp;Search Unicode CJK Japanese phonetic Kana (Asian)<br>
        <input name="unicode[]" value="cyrillic" type="checkbox"> &nbsp;Search Unicode Cyrillic (Russian)<br>
        <input name="unicode[]" value="nobom" type="checkbox"> &nbsp;Search Unicode 16 without a byte-order-mark; alt.: Search Unicode 8 and 16 without a byte-order-mark; NOTE: (explore using Autopsy): is it just the UTF-16 files that have no BOM? or do the UTF-8 and ASCII files have no BOM also? i.e., what are we testing?<br>
        <input name="unicode[]" value="norm" type="checkbox"> &nbsp;Search Unicode for normalized diacritic marks (NFC &amp; NFD) and ligatures (NFKC &amp; NFKD)<br>
		<input name="unicode[]" value="rtl" type="checkbox"> &nbsp;Search Unicode RTL (Arabic)<br></p>
    </div>
    <br>
	
<!--	  <h2 style="font-size:1.6em">Operations on Partitions</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Search Tool Defined Queries</b></h3> 
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of tool pre-defined queries you want to test for the tool. At a minimum, 
		you should consider testing the types of pre-defined queries you use in your lab.</p>        

        <p>What tool pre-defined queries do you want to test? <br>
		<input name="tool_defined[]" value="email" type="checkbox">&nbsp; Email Address <br>
        <input name="tool_defined[]" value="phone" type="checkbox">&nbsp; Telephone Number<br>
        <input name="tool_defined[]" value="ss" type="checkbox">&nbsp; Social Security <br></p>
		
	</div>
    <br>

<!--      <h2 style="font-size:1.6em">Error Condition Tests</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Special Cases</b></h3> 
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the special situations you want to test for the tool.</p>
		
        <p>What special situations do you want to test? <br>
		<input name="special[]" value="doc" type="checkbox"> Search Formatted Document Text &nbsp;<br>
        <input name="special[]" value="frag" type="checkbox"> Search Fragmented File &nbsp;<br>
        <input name="special[]" value="lost" type="checkbox"> Search Inaccessible (lost) Areas &nbsp;<br>
        <input name="special[]" value="mft" type="checkbox"> Search File in MFT &nbsp; <br>
        <input name="special[]" value="meta" type="checkbox"> Search file name substring in Meta-data &nbsp;<br>
        <input name="special[]" value="stem" type="checkbox"> Search for matches to word stem<br></p>
		
	</div>
    <br>

<!--      <h2 style="font-size:1.6em">Hash Operations and Hashes</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Regular Expressions</b></h3>
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of regular expression searches you want 
        to test for the tool. You should consider testing the tool for the types of 
        regular expression searches you use the tool for in your lab.</p>

        <p>What regular expression searches do you want to test? <br>
		<input name="regex[]" value="hex" type="checkbox">&nbsp; Search Hexadecimal Character Match <br>
        <input name="regex[]" value="regex" type="checkbox">&nbsp; Search Pattern Character Match <br></p>
		
</div><br>
	
	
&nbsp;&nbsp;&nbsp;&nbsp;<input value="Next" type="submit">         
</form>
</p>

<?php
/*
*/
//include "ft_ss_home_links.php";
?>
<?php
}  // endif($ftlogs_mounted==1)
include "ft_ss_tail.php";
?>

